/* **************************************************************************************************** */
CREATE OR REPLACE FUNCTION W83B.W83BCOMEXTRACCIONDATOS(sindicato NUMBER, tipovoz NUMBER, voz NUMBER, sino NUMBER)
     RETURN tabla_COMEXTRACCIONDATOS
     IS
         v_tabla_COMEXTRACCIONDATOS tabla_COMEXTRACCIONDATOS := tabla_COMEXTRACCIONDATOS();
         nacta NUMBER;
         anoacta NUMBER;
         territ VARCHAR2(2);
         nactacompleto NUMBER;
         nimpug NUMBER;
         anoimpug NUMBER;
         nlaudo NUMBER;
         anolaudo NUMBER;
         flaudo DATE;
         arbitro VARCHAR2(250);
         cif VARCHAR2(10);
         razonsocial VARCHAR2(50);
         sindicatos VARCHAR2(5000);
         voces VARCHAR2(5000);
         orderbyvar VARCHAR2(1);
         contador NUMBER:=1;
         valido boolean:=false;
         sind emb_string.string_array;
         s emb_string.string_array;
         vo emb_string.string_array;
         v emb_string.string_array;
       CURSOR actasConsultar IS
/* Formatted on 2012/05/22 12:33 (Formatter Plus v4.8.8) */
SELECT   consulta.nacta, consulta.anoacta, consulta.territ, 
        TO_NUMBER
                   ( consulta.anoacta
                    || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                               1, '00000' || TO_CHAR (consulta.nacta),
                               2, '0000' || TO_CHAR (consulta.nacta),
                               3, '000' || TO_CHAR (consulta.nacta),
                               4, '00' || TO_CHAR (consulta.nacta),
                               5, '0' || TO_CHAR (consulta.nacta),
                               TO_CHAR (consulta.nacta)
                              )
                   ) AS nactacompleto,
        consulta.nimpug,
         consulta.anoimpug, consulta.nlaudo, consulta.anolaudo,
         consulta.flaudo, consulta.arbitro, consulta.cif,
         consulta.razonsocial, consulta.sindicatos, consulta.orderby,
         (SELECT CASE
                    WHEN (stragg_int (vocesimpug.ctipvoz_034) IS NOT NULL)
                       THEN stragg_int (   vocesimpug.ctipvoz_034
                                        || '|'
                                        || vocesimpug.cvoz_034
                                        || '|'
                                        || vocesimpug.sino_034
                                        || '|'
                                        || voces.desc_031
                                        || '|'
                                        || voces.dese_031
                                       )
                    ELSE ''
                 END
            FROM w83b34s00 vocesimpug, w83b31s00 voces
           WHERE consulta.nimpug = vocesimpug.n_impug_034
             AND consulta.anoimpug = vocesimpug.ano_impug_034
             AND consulta.nlaudo = vocesimpug.n_laudo_034
             AND consulta.anolaudo = vocesimpug.ano_laudo_034
             AND consulta.territ = vocesimpug.c_territ_034
             AND vocesimpug.cvoz_034 = voces.cvoz_031
             AND vocesimpug.ctipvoz_034 = voces.ctipvoz_031)
    FROM (SELECT   preavisos.n_preaviso_037 AS nacta,
                   preavisos.ano_preaviso_037 AS anoacta,
                   preavisos.c_territ_037 AS territ,
                   impugnaciones.n_impug_033 AS nimpug,
                   impugnaciones.ano_impug_033 AS anoimpug,
                   laudos.n_laudo_068 AS nlaudo,
                   laudos.ano_laudo_068 AS anolaudo,
                   laudos.flaudo_068 AS flaudo,
                   arbitros.nombre_036 AS arbitro, centros.ccif_001 AS cif,
                   centros.rsoc_001 AS razonsocial,
                   CASE
                      WHEN (stragg_int (sindimp.c_sindi_035) IS NOT NULL
                           )
                         THEN stragg_int (   sindimp.c_sindi_035
                                          || '|'
                                          || sindicatos.siglas_019
                                         )
                      ELSE ''
                   END AS sindicatos,
                   '2' AS orderby                                            --,
--CASE WHEN(STRAGG_INT(TIPOVOCES.CTIPVOZ_032) IS NOT NULL) THEN STRAGG_INT(TIPOVOCES.CTIPVOZ_032) ELSE '' END
          FROM     w83b37s00 preavisos,
                   j7301s01 centros,
                   w83b33s00 impugnaciones,
                   w83b36s00 arbitros,
                   w83b35s00 sindimp,
                   w83b19s00 sindicatos,
                   w83b68s00 laudos
                   --,W83B34S00 VOCESIMPUG,W83B31S00 VOCES,W83B32S00 TIPOVOCES
             WHERE centros.ccen_001 = preavisos.id_centro_037
               AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033
               AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033
               AND preavisos.c_territ_037 = impugnaciones.c_territ_033
               AND impugnaciones.dni_033 = arbitros.dni_036(+)
               AND impugnaciones.n_impug_033 = sindimp.n_impug_035(+)
               AND impugnaciones.ano_impug_033 = sindimp.ano_impug_035(+)
               AND impugnaciones.c_territ_033 = sindimp.c_territ_035(+)
               AND sindimp.c_sindi_035 = sindicatos.c_sindi_019(+)
               AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
               AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
               AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
--AND VOCES.CTIPVOZ_031=TIPOVOCES.CTIPVOZ_032
          GROUP BY preavisos.n_preaviso_037,
                   preavisos.ano_preaviso_037,
                   preavisos.c_territ_037,
                   impugnaciones.n_impug_033,
                   impugnaciones.ano_impug_033,
                   laudos.n_laudo_068,
                   laudos.ano_laudo_068,
                   laudos.flaudo_068,
                   arbitros.nombre_036,
                   centros.ccif_001,
                   centros.rsoc_001,
                   '2') consulta
UNION ALL
SELECT   consulta.nacta, consulta.anoacta, consulta.territ,
            TO_NUMBER
                   ( consulta.anoacta
                    || DECODE (LENGTH (TO_CHAR (consulta.nacta)),
                               1, '00000' || TO_CHAR (consulta.nacta),
                               2, '0000' || TO_CHAR (consulta.nacta),
                               3, '000' || TO_CHAR (consulta.nacta),
                               4, '00' || TO_CHAR (consulta.nacta),
                               5, '0' || TO_CHAR (consulta.nacta),
                               TO_CHAR (consulta.nacta)
                              )
                   ) AS nactacompleto, 
         consulta.nimpug,
         consulta.anoimpug, consulta.nlaudo, consulta.anolaudo,
         consulta.flaudo, consulta.arbitro, consulta.cif,
         consulta.razonsocial, consulta.sindicatos, consulta.orderby,
         (SELECT CASE
                    WHEN (stragg_int (vocesimpug.ctipvoz_034) IS NOT NULL)
                       THEN stragg_int (   vocesimpug.ctipvoz_034
                                        || '|'
                                        || vocesimpug.cvoz_034
                                        || '|'
                                        || vocesimpug.sino_034
                                        || '|'
                                        || voces.desc_031
                                        || '|'
                                        || voces.dese_031
                                       )
                    ELSE ''
                 END
            FROM w83b34s00 vocesimpug, w83b31s00 voces
           WHERE consulta.nimpug = vocesimpug.n_impug_034
             AND consulta.anoimpug = vocesimpug.ano_impug_034
             AND consulta.nlaudo = vocesimpug.n_laudo_034
             AND consulta.anolaudo = vocesimpug.ano_laudo_034
             AND consulta.territ = vocesimpug.c_territ_034
             AND vocesimpug.cvoz_034 = voces.cvoz_031
             AND vocesimpug.ctipvoz_034 = voces.ctipvoz_031)
    FROM (SELECT   actas.n_acta_016 AS nacta, actas.ano_acta_016 anoacta,
                   actas.c_territ_016 AS territ,
                   impugnaciones.n_impug_033 AS nimpug,
                   impugnaciones.ano_impug_033 AS anoimpug,
                   laudos.n_laudo_068 AS nlaudo,
                   laudos.ano_laudo_068 AS anolaudo,
                   laudos.flaudo_068 AS flaudo,
                   arbitros.nombre_036 AS arbitro, centros.ccif_001 AS cif,
                   centros.rsoc_001 AS razonsocial,
                   CASE
                      WHEN (stragg_int (sindimp.c_sindi_035) IS NOT NULL
                           )
                         THEN stragg_int (   sindimp.c_sindi_035
                                          || '|'
                                          || sindicatos.siglas_019
                                         )
                      ELSE ''
                   END AS sindicatos,
                   '1' AS orderby                                            --,
--CASE WHEN(STRAGG_INT(TIPOVOCES.CTIPVOZ_032) IS NOT NULL) THEN STRAGG_INT(TIPOVOCES.CTIPVOZ_032) ELSE '' END
          FROM     w83b16s00 actas,
                   j7301s01 centros,
                   w83b33s00 impugnaciones,
                   w83b36s00 arbitros,
                   w83b35s00 sindimp,
                   w83b19s00 sindicatos,
                   w83b68s00 laudos
                   --,W83B34S00 VOCESIMPUG,W83B31S00 VOCES,W83B32S00 TIPOVOCES
             WHERE centros.ccen_001 = actas.id_centro_016
               AND actas.n_acta_016 = impugnaciones.n_acta_033
               AND actas.ano_acta_016 = impugnaciones.ano_acta_033
               AND actas.c_territ_016 = impugnaciones.c_territ_033
               AND actas.version_016 = impugnaciones.version_033
               AND impugnaciones.dni_033 = arbitros.dni_036(+)
               AND impugnaciones.n_impug_033 = sindimp.n_impug_035(+)
               AND impugnaciones.ano_impug_033 = sindimp.ano_impug_035(+)
               AND impugnaciones.c_territ_033 = sindimp.c_territ_035(+)
               AND sindimp.c_sindi_035 = sindicatos.c_sindi_019(+)
               AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
               AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
               AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
--AND VOCES.CTIPVOZ_031=TIPOVOCES.CTIPVOZ_032
               AND actas.version_016 = 0
               AND actas.validada_016 = 1
               AND actas.f_baja_016 IS NULL
          GROUP BY actas.n_acta_016,
                   actas.ano_acta_016,
                   actas.c_territ_016,
                   impugnaciones.n_impug_033,
                   impugnaciones.ano_impug_033,
                   laudos.n_laudo_068,
                   laudos.ano_laudo_068,
                   laudos.flaudo_068,
                   arbitros.nombre_036,
                   centros.ccif_001,
                   centros.rsoc_001,
                   '1') consulta
ORDER BY nlaudo, anolaudo, territ, orderby;

   BEGIN
       OPEN actasConsultar;
       LOOP
         FETCH actasConsultar INTO  nacta,anoacta,territ,nactacompleto,nimpug,anoimpug,nlaudo,anolaudo,flaudo,arbitro,cif,razonsocial,sindicatos,orderbyvar,voces;
            EXIT WHEN actasConsultar%NOTFOUND;
            if (sindicato=-1 AND voz=-1 AND tipovoz=-1) then
                valido:=true;
            else
                if (sindicato!=-1) then
                    valido:=false;
                    sind := emb_string.split_string(sindicatos,'?');
                    for i in 1..sind.count loop
                        s := emb_string.split_string(sind(i),'|');
                        if (s(1)=sindicato) then
                            valido:=true;
                        end if;
                    exit when valido = true;
                    end loop;
                end if;
                if (tipovoz!=-1 AND voz!=-1) then
                    valido:=false;
                    vo := emb_string.split_string(voces,'?');
                    for j in 1..vo.count loop
                        v := emb_string.split_string(vo(j),'|');
                        if (v(1)=tipovoz AND v(2)=voz AND v(3)=sino) then
                            valido:=true;
                        end if;
                        exit when valido = true;
                    end loop;
                else if ( tipovoz!=-1 AND voz=-1) then
                    valido:=false;
                    vo := emb_string.split_string(voces,'?');
                    for h in 1..vo.count loop
                        v := emb_string.split_string(vo(h),'|');
                        if (v(1)=tipovoz) then
                            valido:=true;
                        end if;
                        exit when valido = true;
                    end loop;
                end if;
             end if; 
            end if;
            if (valido) then
                 v_tabla_COMEXTRACCIONDATOS.EXTEND;
                            v_tabla_COMEXTRACCIONDATOS(contador) := COMEXTRACCIONDATOS(nacta,anoacta,territ,nactacompleto,nimpug,anoimpug,nlaudo,anolaudo,flaudo,arbitro,cif,razonsocial,sindicatos,voces,orderbyvar);
                            contador:=contador+1;
                end if;               
        END LOOP;
        CLOSE actasConsultar;
   RETURN v_tabla_COMEXTRACCIONDATOS;

END W83BCOMEXTRACCIONDATOS;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FUNCTION W83B.w83bcomimpugresueltas(fimpugdesde IN VARCHAR2, fimpughasta IN VARCHAR2, territorio IN VARCHAR2, patron IN VARCHAR2)
     RETURN tabla_comimpugresueltas
     IS
         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas();
         nactaVar NUMBER;
         anoactaVar NUMBER;
         territVar VARCHAR2(50);
         razonVar VARCHAR2(50);
         domicilioVar VARCHAR2(50);
         municipioVar NUMBER;
         provinciaVar NUMBER;
         nimpugVar VARCHAR2(10000);
         numactaintVar NUMBER;
         numactacompletaVar NUMBER;
         orderbyVar VARCHAR2(1);
         contador NUMBER:=1;
         codigopostalVar VARCHAR2(5);
         dirorig VARCHAR2(200);
         cporig VARCHAR2(5);
         munorig VARCHAR2(3);
         provorig VARCHAR2(2);
       CURSOR actasConsultar IS
SELECT   actas.n_acta_016 AS nacta, actas.ano_acta_016 AS anoacta,
            actas.c_territ_016 AS territ, centros.rsoc_001 AS razon,
            centros.domic_001 AS domicilio, centros.munic_001 AS municipio,
            centros.provc_001 AS provincia, stragg(impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||to_char(laudos.FLAUDO_068,'dd/MM/yyyy')) AS nimpug,
            TO_NUMBER
                   (   actas.c_territ_016
                    || actas.ano_acta_016
                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                               1, '00000' || TO_CHAR (actas.n_acta_016),
                               2, '0000' || TO_CHAR (actas.n_acta_016),
                               3, '000' || TO_CHAR (actas.n_acta_016),
                               4, '00' || TO_CHAR (actas.n_acta_016),
                               5, '0' || TO_CHAR (actas.n_acta_016),
                               TO_CHAR (actas.n_acta_016)
                              )
                   ) AS numaactaint,
            TO_NUMBER
                   ( actas.ano_acta_016
                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                               1, '00000' || TO_CHAR (actas.n_acta_016),
                               2, '0000' || TO_CHAR (actas.n_acta_016),
                               3, '000' || TO_CHAR (actas.n_acta_016),
                               4, '00' || TO_CHAR (actas.n_acta_016),
                               5, '0' || TO_CHAR (actas.n_acta_016),
                               TO_CHAR (actas.n_acta_016)
                              )
                   ) AS numaactacompleta,
            '1' AS orderby,
            centros.CPOSC_001 as codigopostal,
            preavisos.dir_alt_037 AS dirorig,
            preavisos.codpos_alt_037 AS cporig,
            preavisos.mun_alt_037 AS munorig,
            preavisos.prov_alt_037 AS provorig
       FROM w83b16s00 actas,
            j7301s01 centros,
            w83b33s00 impugnaciones,
            w83b68s00 laudos,
            w83b37s00 preavisos
      WHERE centros.ccen_001 = actas.id_centro_016
        AND actas.n_acta_016 = impugnaciones.n_acta_033
        AND actas.ano_acta_016 = impugnaciones.ano_acta_033
        AND actas.c_territ_016 = impugnaciones.c_territ_033
        AND actas.version_016 = impugnaciones.version_033
        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
        AND actas.N_PREAVISO_016=preavisos.N_PREAVISO_037(+)
        AND actas.ANO_PREAVISO_016=preavisos.ANO_PREAVISO_037(+)
        AND actas.C_TERRIT_016=preavisos.C_TERRIT_037(+)
        AND impugnaciones.FDESES_033 IS NULL
        AND actas.version_016 = 0
        AND actas.validada_016 = 1
        AND actas.F_BAJA_016 IS NULL
        AND actas.c_territ_016 = territorio
        AND f_impug_033 >= TO_DATE (fimpugdesde, patron)
        AND f_impug_033 <= TO_DATE (fimpughasta, patron)
      GROUP BY
      actas.n_acta_016, actas.ano_acta_016,
            actas.c_territ_016, centros.rsoc_001,
            centros.domic_001, centros.munic_001,
            centros.provc_001,
            TO_NUMBER
                   (   actas.c_territ_016
                    || actas.ano_acta_016
                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                               1, '00000' || TO_CHAR (actas.n_acta_016),
                               2, '0000' || TO_CHAR (actas.n_acta_016),
                               3, '000' || TO_CHAR (actas.n_acta_016),
                               4, '00' || TO_CHAR (actas.n_acta_016),
                               5, '0' || TO_CHAR (actas.n_acta_016),
                               TO_CHAR (actas.n_acta_016)
                              )
                   ),
            '1',
            centros.CPOSC_001,
            preavisos.dir_alt_037,
            preavisos.codpos_alt_037,
            preavisos.mun_alt_037,
            preavisos.prov_alt_037
   UNION ALL
   SELECT   preavisos.n_preaviso_037 AS nacta,
            preavisos.ano_preaviso_037 AS anoacta,
            preavisos.c_territ_037 AS territ, centros.rsoc_001 AS razon,
            centros.domic_001 AS domicilio, centros.munic_001 AS municipio,
            centros.provc_001 AS provincia, stragg(impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||to_char(laudos.FLAUDO_068,'dd/MM/yyyy')) AS nimpug,
            TO_NUMBER
               (   preavisos.c_territ_037
                || preavisos.ano_preaviso_037
                || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                           1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                           2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                           3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                           4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                           5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                           TO_CHAR (preavisos.n_preaviso_037)
                          )
               ) AS numaactaint,
            TO_NUMBER
                   ( preavisos.ano_preaviso_037
                    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                               1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                               2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                               3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                               4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                               5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                               TO_CHAR (preavisos.n_preaviso_037)
                              )
                   ) AS numaactacompleta,
            '2' AS orderby,
            centros.CPOSC_001 as codigopostal,
            preavisos.dir_alt_037 AS dirorig,
            preavisos.codpos_alt_037 AS cporig,
            preavisos.mun_alt_037 AS munorig,
            preavisos.prov_alt_037 AS provorig
       FROM w83b37s00 preavisos,
            j7301s01 centros,
            w83b33s00 impugnaciones,
            w83b68s00 laudos
      WHERE centros.ccen_001 = preavisos.id_centro_037
        AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033
        AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033
        AND preavisos.c_territ_037 = impugnaciones.c_territ_033
        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
        AND impugnaciones.FDESES_033 IS NULL
        AND preavisos.c_territ_037 = territorio
        AND f_impug_033 >= TO_DATE (fimpugdesde, patron)
        AND f_impug_033 <= TO_DATE (fimpughasta, patron)
     GROUP BY
      preavisos.n_preaviso_037,
            preavisos.ano_preaviso_037,
            preavisos.c_territ_037, centros.rsoc_001,
            centros.domic_001, centros.munic_001,
            centros.provc_001, 
            TO_NUMBER
               (   preavisos.c_territ_037
                || preavisos.ano_preaviso_037
                || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                           1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                           2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                           3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                           4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                           5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                           TO_CHAR (preavisos.n_preaviso_037)
                          )
               ),
            '2',
            centros.CPOSC_001,
            preavisos.dir_alt_037,
            preavisos.codpos_alt_037,
            preavisos.mun_alt_037,
            preavisos.prov_alt_037
   ORDER BY orderby, numaactaint;

   BEGIN
       OPEN actasConsultar;
       LOOP
         FETCH actasConsultar INTO nactaVar,anoactaVar,territVar,razonVar,
         domicilioVar,municipioVar,provinciaVar,nimpugVar,numactaintVar,numactacompletaVar,orderbyVar,codigopostalVar,dirorig,
            cporig,
            munorig,
            provorig;
            EXIT WHEN actasConsultar%NOTFOUND;
                            v_tabla_comimpugresueltas.EXTEND;
                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,
                            anoactaVar,
                            territVar,
                            razonVar,
                            domicilioVar,
                            municipioVar,
                            provinciaVar,
                            nimpugVar,
                            numactacompletaVar,
                            codigopostalVar,
                            orderbyVar,dirorig,
                            cporig,
                            munorig,
                            provorig);
                            contador:=contador+1;
        END LOOP;
        CLOSE actasConsultar;
   RETURN v_tabla_comimpugresueltas;

END w83bcomimpugresueltas;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FUNCTION W83B.w83bcomlaudosresueltos(territorio IN VARCHAR2)
     RETURN tabla_comimpugresueltas
     IS
         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas();
         nactaVar NUMBER;
         anoactaVar NUMBER;
         territVar VARCHAR2(50);
         razonVar VARCHAR2(50);
         domicilioVar VARCHAR2(50);
         municipioVar NUMBER;
         provinciaVar NUMBER;
         numactaintVar NUMBER;
         orderbyVar VARCHAR2(1);
         codigopostalVar VARCHAR2(5);
         contador NUMBER:=1;
         nimpugVar VARCHAR2(10000);
         numactacompletaVar NUMBER;
         fd emb_string.string_array;
         dirorig VARCHAR2(200);
         cporig VARCHAR2(5);
         munorig VARCHAR2(3);
         provorig VARCHAR2(2);
         CURSOR actasConsultar IS
SELECT  actas.n_acta_016 AS nacta,
        actas.ano_acta_016 AS anoacta,
        actas.c_territ_016 AS territ,
        centros.rsoc_001 AS razon,
        centros.domic_001 AS domicilio,
        centros.munic_001 AS municipio,centros.provc_001 AS provincia,  
        stragg (impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||NVL(to_char(laudos.FLAUDO_068,'dd/MM/yyyy'),'0')||'|'||NVL(to_char(impugnaciones.FDESES_033,'dd/MM/yyyy'),'0')) as nimpug,
        TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                         ) AS numaactaint,
             TO_NUMBER
                   ( actas.ano_acta_016
                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                               1, '00000' || TO_CHAR (actas.n_acta_016),
                               2, '0000' || TO_CHAR (actas.n_acta_016),
                               3, '000' || TO_CHAR (actas.n_acta_016),
                               4, '00' || TO_CHAR (actas.n_acta_016),
                               5, '0' || TO_CHAR (actas.n_acta_016),
                               TO_CHAR (actas.n_acta_016)
                              )
                   ) AS numaactacompleta,
            '1' AS orderby,
            centros.CPOSC_001 as codigopostal,
            preavisos.dir_alt_037 AS dirorig,
            preavisos.codpos_alt_037 AS cporig,
            preavisos.mun_alt_037 AS munorig,
            preavisos.prov_alt_037 AS provorig
       FROM w83b16s00 actas,
            w83b33s00 impugnaciones,
            w83b68s00 laudos,
            j7301s01 centros,
            w83b37s00 preavisos
      WHERE centros.ccen_001 = actas.id_centro_016
        AND actas.n_acta_016 = impugnaciones.n_acta_033
        AND actas.ano_acta_016 = impugnaciones.ano_acta_033
        AND actas.c_territ_016 = impugnaciones.c_territ_033
        AND actas.version_016 = impugnaciones.version_033
        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
        AND actas.N_PREAVISO_016 = preavisos.N_PREAVISO_037(+)
        AND actas.ANO_PREAVISO_016 = preavisos.ANO_PREAVISO_037(+)
        AND actas.C_TERRIT_016 = preavisos.C_TERRIT_037(+)
        AND actas.c_territ_016 = territorio
        AND actas.version_016 = 0
        AND actas.validada_016 = 1
        AND actas.F_BAJA_016 IS NULL
       GROUP BY
        actas.n_acta_016,
        actas.ano_acta_016,
        actas.c_territ_016,
        centros.rsoc_001,
        centros.domic_001,
        centros.munic_001,
        centros.PROVC_001,
        TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                         ),
                       '1' ,
                       centros.CPOSC_001,
                       preavisos.dir_alt_037,
            preavisos.codpos_alt_037,
            preavisos.mun_alt_037,
            preavisos.prov_alt_037 
UNION ALL

SELECT  preavisos.n_preaviso_037 AS nacta,
        preavisos.ano_preaviso_037 AS anoacta,
        preavisos.c_territ_037 AS territ,
        centros.rsoc_001 AS razon,
        centros.domic_001 AS domicilio,
        centros.munic_001 AS municipio,centros.provc_001 AS provincia,         
        stragg (impugnaciones.n_impug_033||'|'||impugnaciones.ano_impug_033||'|'||NVL(to_char(laudos.FLAUDO_068,'dd/MM/yyyy'),'0')||'|'||NVL(to_char(impugnaciones.FDESES_033,'dd/MM/yyyy'),'0')) as nimpug,
        TO_NUMBER
                         (   preavisos.c_territ_037
                          || preavisos.ano_preaviso_037
                          || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                                     1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                                     2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                                     3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                                     4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                                     5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                                     TO_CHAR (preavisos.n_preaviso_037)
                                    )
                         ) AS numaactaint,
            TO_NUMBER
                   ( preavisos.ano_preaviso_037
                    || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                               1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                               2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                               3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                               4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                               5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                               TO_CHAR (preavisos.n_preaviso_037)
                              )
                   ) AS numaactacompleta,
            '2' AS orderby,
            centros.CPOSC_001 as codigopostal,
            preavisos.dir_alt_037 AS dirorig,
            preavisos.codpos_alt_037 AS cporig,
            preavisos.mun_alt_037 AS munorig,
            preavisos.prov_alt_037 AS provorig
       FROM w83b37s00 preavisos,
            w83b33s00 impugnaciones,
            w83b68s00 laudos,
            j7301s01 centros
      WHERE centros.ccen_001 = preavisos.id_centro_037
        AND preavisos.n_preaviso_037 = impugnaciones.n_preaviso_033
        AND preavisos.ano_preaviso_037 = impugnaciones.ano_preaviso_033
        AND preavisos.c_territ_037 = impugnaciones.c_territ_033
        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068(+)
        AND impugnaciones.n_impug_033 = laudos.n_impug_068(+)
        AND impugnaciones.c_territ_033 = laudos.c_territ_068(+)
        AND preavisos.c_territ_037 =territorio
       GROUP BY
        preavisos.n_preaviso_037,
        preavisos.ano_preaviso_037,
        preavisos.c_territ_037,
        centros.rsoc_001,
        centros.domic_001,
        centros.munic_001,
        centros.PROVC_001,
        TO_NUMBER
                         (   preavisos.c_territ_037
                          || preavisos.ano_preaviso_037
                          || DECODE (LENGTH (TO_CHAR (preavisos.n_preaviso_037)),
                                     1, '00000' || TO_CHAR (preavisos.n_preaviso_037),
                                     2, '0000' || TO_CHAR (preavisos.n_preaviso_037),
                                     3, '000' || TO_CHAR (preavisos.n_preaviso_037),
                                     4, '00' || TO_CHAR (preavisos.n_preaviso_037),
                                     5, '0' || TO_CHAR (preavisos.n_preaviso_037),
                                     TO_CHAR (preavisos.n_preaviso_037)
                                    )
                         ),
                       '2' ,
                       centros.CPOSC_001,
                       preavisos.dir_alt_037,
            preavisos.codpos_alt_037,
            preavisos.mun_alt_037,
            preavisos.prov_alt_037 
  ORDER BY orderby,numaactaint;            
   BEGIN
       OPEN actasConsultar;     
       LOOP
         FETCH actasConsultar INTO nactaVar,anoactaVar,territVar,razonVar,
         domicilioVar,municipioVar,provinciaVar,nimpugVar,numactaintVar,numactacompletaVar,orderbyVar,codigopostalVar,dirorig,
            cporig,
            munorig,
            provorig;
            EXIT WHEN actasConsultar%NOTFOUND;
                            v_tabla_comimpugresueltas.EXTEND;
                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,
                            anoactaVar,
                            territVar,
                            razonVar,
                            domicilioVar,
                            municipioVar,
                            provinciaVar,
                            nimpugVar,
                            numactacompletaVar,
                            codigopostalVar,
                            orderbyVar,dirorig,
            cporig,
            munorig,
            provorig);
                            contador:=contador+1;
                          
        END LOOP;
        CLOSE actasConsultar;
   RETURN v_tabla_comimpugresueltas;
   
END w83bcomlaudosresueltos;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FUNCTION W83B.w83bcomlaudonegativo(fechaentrada IN VARCHAR2,territorio IN VARCHAR2, patron IN VARCHAR2)
     RETURN tabla_comimpugresueltas
     IS
         v_tabla_comimpugresueltas tabla_comimpugresueltas := tabla_comimpugresueltas(); 
         fechaEntradaVar DATE;
         nactaVar number;
         anoactaVar number;
         territVar varchar2(2);
         razonVar varchar2(50);
         domicilioVar varchar2(50);
         municipioVar NUMBER;
         provinciaVar NUMBER;
         codigopostalVar varchar2(5);
         fimpugVar DATE;
         contador number:=1;
         fechalaudoVar varchar2(10000);
         rd emb_string.string_array;
         fd emb_string.string_array;
         numaactaintVar number;
         fechavalida boolean:=false;
         dirorig VARCHAR2(200);
         cporig VARCHAR2(5);
         munorig VARCHAR2(3);
         provorig VARCHAR2(2);
         
         CURSOR actasConsultar IS
SELECT actas.f_entra_016 AS fechaentrada,
        actas.n_acta_016 AS nacta,
        actas.ano_acta_016 AS anoacta,
        actas.c_territ_016 AS territ,
        centros.rsoc_001 AS razon,
        centros.domic_001 AS domicilio,
        centros.CPOSC_001 AS codigopostal,
        centros.MUNIC_001 AS municipio,
        centros.PROVC_001 AS provincia,
        MAX (impugnaciones.f_impug_033) AS fimpug,              
        NVL(stragg (to_char(laudos.FLAUDO_068,'dd/MM/yyyy')||'|'||laudos.rdo_laudo_068),0) as fechalaudo,
        TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                         ) AS numaactaint,
                         preavisos.dir_alt_037 AS dirorig,
            preavisos.codpos_alt_037 AS cporig,
            preavisos.mun_alt_037 AS munorig,
            preavisos.prov_alt_037 AS provorig
       FROM w83b16s00 actas,
            w83b33s00 impugnaciones,
            w83b68s00 laudos,
            j7301s01 centros,
            w83b37s00 preavisos
      WHERE centros.ccen_001 = actas.id_centro_016
        AND actas.n_acta_016 = impugnaciones.n_acta_033
        AND actas.ano_acta_016 = impugnaciones.ano_acta_033
        AND actas.c_territ_016 = impugnaciones.c_territ_033
        AND actas.version_016 = impugnaciones.version_033
        AND impugnaciones.ano_impug_033 = laudos.ano_impug_068
        AND impugnaciones.n_impug_033 = laudos.n_impug_068
        AND impugnaciones.c_territ_033 = laudos.c_territ_068
        AND actas.N_PREAVISO_016=preavisos.N_PREAVISO_037(+)
        AND actas.ANO_PREAVISO_016=preavisos.ANO_PREAVISO_037(+)
        AND actas.C_TERRIT_016=preavisos.C_TERRIT_037(+)
        AND actas.c_territ_016 = territorio
        AND actas.validada_016 = 1
        AND actas.F_BAJA_016 IS NULL
       GROUP BY
        actas.f_entra_016,
        actas.n_acta_016,
        actas.ano_acta_016,
        actas.c_territ_016,
        centros.rsoc_001,
        centros.domic_001,
        centros.CPOSC_001,
        centros.MUNIC_001,
        centros.PROVC_001,        
        TO_NUMBER
                         (   actas.c_territ_016
                          || actas.ano_acta_016
                          || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                     1, '00000' || TO_CHAR (actas.n_acta_016),
                                     2, '0000' || TO_CHAR (actas.n_acta_016),
                                     3, '000' || TO_CHAR (actas.n_acta_016),
                                     4, '00' || TO_CHAR (actas.n_acta_016),
                                     5, '0' || TO_CHAR (actas.n_acta_016),
                                     TO_CHAR (actas.n_acta_016)
                                    )
                         ),
                         preavisos.dir_alt_037,
            preavisos.codpos_alt_037,
            preavisos.mun_alt_037,
            preavisos.prov_alt_037
   ORDER BY numaactaint;                          
   BEGIN
       OPEN actasConsultar;     
       LOOP
         FETCH actasConsultar INTO fechaEntradaVar,nactaVar,anoactaVar,
         territVar,razonVar,domicilioVar,codigopostalVar,municipioVar,provinciaVar,fimpugVar,fechalaudoVar,numaactaintVar,
            dirorig,
            cporig,
            munorig,
            provorig;
            fechavalida:=false;
            EXIT WHEN actasConsultar%NOTFOUND;
            if (fechalaudoVar!='0') then
                 fd := emb_string.split_string(fechalaudoVar);
                 for i in 1..fd.count loop
                    rd := emb_string.split_string(fd(i),'|');
                    if (rd(2)=1) then
                        if (TO_DATE(rd(1),patron)>=TO_DATE(fechaentrada,patron)) then
                            v_tabla_comimpugresueltas.EXTEND;
                            v_tabla_comimpugresueltas(contador) := comimpugresueltas(nactaVar,
                            anoactaVar,
                            territVar,
                            razonVar,
                            domicilioVar,
                            municipioVar,
                            provinciaVar,
                            '0','0',
                            codigopostalVar,
                            '0',
                            dirorig,
                            cporig,
            munorig,
            provorig
            );
                            contador:=contador+1;
                            fechavalida:=true;
                        end if;
                    end if;
                    EXIT WHEN fechavalida = true;
                end loop;
            end if;
        END LOOP;
        CLOSE actasConsultar;
   RETURN v_tabla_comimpugresueltas;   
END w83bcomlaudonegativo;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.w83bdeshacerregistro (ver,
                                                        anoacta,
                                                        territorio,
                                                        numacta,
                                                        fechaentrada,
                                                        cif,
                                                        numcentro,
                                                        razonsocial,
                                                        direccion,
                                                        numtrabajadores,
                                                        municipio,
                                                        provincia,
                                                        nueva,
                                                        seccion,
                                                        fecharegistro,
                                                        numentrada,
                                                        factu,
                                                        numrepresentantes,
                                                        numaactaint
                                                       )
AS
   SELECT   actas.version_016, actas.ano_acta_016, actas.c_territ_016,
            actas.n_acta_016, actas.f_entra_016, centros.ccif_001,
            centros.ncen_001, centros.rsoc_001, centros.domic_001,
            actas.totelec_016, centros.munic_001, centros.provc_001,
            actas.nueva_016, centros.secc_001, actas.fregdef_016,
               actas.c_territ_016
            || '/'
            || actas.ano_acta_016
            || '/'
            || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                       1, '00000' || TO_CHAR (actas.n_acta_016),
                       2, '0000' || TO_CHAR (actas.n_acta_016),
                       3, '000' || TO_CHAR (actas.n_acta_016),
                       4, '00' || TO_CHAR (actas.n_acta_016),
                       5, '0' || TO_CHAR (actas.n_acta_016),
                       TO_CHAR (actas.n_acta_016)
                      ),
            actas.factu_016, COUNT (delegados.dni_025) AS numrepresentantes,
            TO_NUMBER
                   (   actas.c_territ_016
                    || actas.ano_acta_016
                    || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                               1, '00000' || TO_CHAR (actas.n_acta_016),
                               2, '0000' || TO_CHAR (actas.n_acta_016),
                               3, '000' || TO_CHAR (actas.n_acta_016),
                               4, '00' || TO_CHAR (actas.n_acta_016),
                               5, '0' || TO_CHAR (actas.n_acta_016),
                               TO_CHAR (actas.n_acta_016)
                              )
                   ) AS numaactaint
       FROM w83b16s00 actas, w83b25s00 delegados, j7301s01 centros
      WHERE actas.n_acta_016 = delegados.n_acta_025(+)
        AND actas.ano_acta_016 = delegados.ano_acta_025(+)
        AND actas.c_territ_016 = delegados.c_territ_025(+)
        AND actas.version_016 = delegados.version_025(+)
        AND actas.id_centro_016 = centros.ccen_001
        AND delegados.f_baja_025(+) IS NULL
        AND actas.f_baja_016 IS NULL
   GROUP BY actas.version_016,
            actas.ano_acta_016,
            actas.c_territ_016,
            actas.n_acta_016,
            actas.f_entra_016,
            centros.ccif_001,
            centros.ncen_001,
            centros.rsoc_001,
            centros.domic_001,
            actas.totelec_016,
            centros.munic_001,
            centros.provc_001,
            nueva_016,
            centros.secc_001,
            actas.fregdef_016,
               actas.c_territ_016
            || '/'
            || actas.ano_acta_016
            || '/'
            || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                       1, '00000' || TO_CHAR (actas.n_acta_016),
                       2, '0000' || TO_CHAR (actas.n_acta_016),
                       3, '000' || TO_CHAR (actas.n_acta_016),
                       4, '00' || TO_CHAR (actas.n_acta_016),
                       5, '0' || TO_CHAR (actas.n_acta_016),
                       TO_CHAR (actas.n_acta_016)
                      ),
            actas.factu_016
   ORDER BY actas.nueva_016 DESC,
            TO_NUMBER (   actas.c_territ_016
                       || actas.ano_acta_016
                       || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                                  1, '00000' || TO_CHAR (actas.n_acta_016),
                                  2, '0000' || TO_CHAR (actas.n_acta_016),
                                  3, '000' || TO_CHAR (actas.n_acta_016),
                                  4, '00' || TO_CHAR (actas.n_acta_016),
                                  5, '0' || TO_CHAR (actas.n_acta_016),
                                  TO_CHAR (actas.n_acta_016)
                                 )
                      ),
            actas.n_acta_016,
            actas.ano_acta_016,
            actas.c_territ_016,
            actas.version_016;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.w83bagrupaciondesccod (c_agru_014,
                                                         f_baja_014,
                                                         desc_014,
                                                         dese_014
                                                        )
AS
   SELECT c_agru_014, f_baja_014, c_agru_014 || '-' || desc_014 AS desc_014,
          c_agru_014 || '-' || dese_014 AS dese_014
     FROM w83b14s00;
/
/* *************************************************************************************************** */
CREATE OR REPLACE FORCE VIEW w83b.w83bdelegagrupconv (codagrup,
                                                      descagrup,
                                                      deseagrup,
                                                      codconvenio,
                                                      descconvenio,
                                                      deseconvenio,
                                                      codsindicato,
                                                      sinddesc,
                                                      sinddese,
                                                      nacta,
                                                      anoacta,
                                                      territ,
                                                      ver,
                                                      felec,
                                                      fecharegistro,
                                                      fechabaja,
                                                      numdelegados
                                                     )
AS
   SELECT   consulta.codagrup, consulta.descagrup, consulta.deseagrup,
            consulta.codconvenio, consulta.descconvenio,
            consulta.deseconvenio, consulta.codsindicato, consulta.sinddesc,
            consulta.sinddese, consulta.nacta, consulta.anoacta,
            consulta.territ, consulta.ver, consulta.felec,
            consulta.fecharegistro, consulta.fechabaja, consulta.numdelegados
       FROM (SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (escrutinios.n_delm_024
                                + escrutinios.n_delh_024
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b13s00 convenios,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones,
                      w83b24s00 escrutinios,
                      w83b19s00 sindicatos
                WHERE actas.c_conv_016 = convenios.c_conv_013
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014
                  AND actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016
             UNION ALL
             SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (diferencias.n_delm_018
                                + diferencias.n_delh_018
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b13s00 convenios,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones,
                      w83b18s00 diferencias,
                      w83b19s00 sindicatos
                WHERE actas.c_conv_016 = convenios.c_conv_013
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014
                  AND actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016) consulta
      WHERE consulta.ver =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.nacta = act.n_acta_016
                   AND consulta.anoacta = act.ano_acta_016
                   AND consulta.territ = c_territ_016
                   AND act.validada_016 = 1)
   ORDER BY consulta.codagrup, consulta.codconvenio, consulta.codsindicato;
/